<?php
/**
 * پنل مدیریت سیستم V2Ray
 * این فایل داشبورد اصلی مدیر سیستم را نمایش می‌دهد
 */

// تنظیم خطاها (در محیط تولید باید غیرفعال شود)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// بررسی ورود مدیر
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// فراخوانی فایل‌های مورد نیاز
require_once '../config/db.php';
require_once '../config/settings.php';
require_once '../config/user.php';
require_once '../config/order.php';
require_once '../config/notification.php';

// تعیین صفحه فعلی
$current_page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';

// تابع برای تبدیل بایت به فرمت خوانا
function formatBytes($bytes, $precision = 2) { 
    $units = ['B', 'KB', 'MB', 'GB', 'TB']; 
    
    $bytes = max($bytes, 0); 
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024)); 
    $pow = min($pow, count($units) - 1); 
    
    $bytes /= (1 << (10 * $pow)); 
    
    return round($bytes, $precision) . ' ' . $units[$pow]; 
}

// تابع برای نمایش تاریخ شمسی
function jdate($format, $timestamp = null) {
    // این را باید با کتابخانه تاریخ شمسی پیاده‌سازی کنید
    // فعلاً از تاریخ میلادی استفاده می‌کنیم
    $timestamp = $timestamp ?: time();
    return date($format, $timestamp);
}

?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پنل مدیریت <?php echo get_setting('app_name', 'V2Ray Manager'); ?></title>
    <!-- Bootstrap RTL -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.rtl.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <!-- Custom CSS -->
    <style>
        body {
            background-color: #f5f5f5;
            font-family: 'Tahoma', 'Segoe UI', sans-serif;
        }
        .sidebar {
            background-color: #343a40;
            color: #fff;
            min-height: 100vh;
            position: sticky;
            top: 0;
        }
        .sidebar-link {
            color: #ffffffcc;
            padding: 10px 15px;
            display: block;
            text-decoration: none;
            transition: all 0.3s;
        }
        .sidebar-link:hover, .sidebar-link.active {
            color: #fff;
            background-color: #0d6efd;
        }
        .main-content {
            padding: 20px;
        }
        .dashboard-card {
            background-color: #fff;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 20px;
            transition: all 0.3s;
        }
        .dashboard-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.15);
        }
        .card-icon {
            font-size: 2rem;
            margin-bottom: 10px;
        }
        .stat-value {
            font-size: 1.8rem;
            font-weight: bold;
        }
        .navbar {
            background-color: #fff;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        .notification-badge {
            position: absolute;
            top: 0;
            right: 0;
            padding: 0.25rem 0.5rem;
            font-size: 0.75rem;
            border-radius: 50%;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 p-0 sidebar">
                <div class="text-center py-4">
                    <img src="<?php echo get_setting('app_logo', '../assets/images/logo.png'); ?>" alt="Logo" height="60">
                    <h4 class="mt-2"><?php echo get_setting('app_name', 'V2Ray Manager'); ?></h4>
                </div>
                <div class="mt-4">
                    <a href="?page=dashboard" class="sidebar-link <?php echo $current_page == 'dashboard' ? 'active' : ''; ?>">
                        <i class="fas fa-tachometer-alt me-2"></i> داشبورد
                    </a>
                    <a href="?page=users" class="sidebar-link <?php echo $current_page == 'users' ? 'active' : ''; ?>">
                        <i class="fas fa-users me-2"></i> مدیریت کاربران
                    </a>
                    <a href="?page=orders" class="sidebar-link <?php echo ($current_page == 'orders' || $current_page == 'order_detail') ? 'active' : ''; ?>">
                        <i class="fas fa-shopping-cart me-2"></i> سفارش‌ها
                        <?php if (count_pending_orders() > 0): ?>
                        <span class="badge bg-danger rounded-pill"><?php echo count_pending_orders(); ?></span>
                        <?php endif; ?>
                    </a>
                    <a href="?page=settings" class="sidebar-link <?php echo $current_page == 'settings' ? 'active' : ''; ?>">
                        <i class="fas fa-cogs me-2"></i> تنظیمات
                    </a>
                    <a href="?page=logs" class="sidebar-link <?php echo $current_page == 'logs' ? 'active' : ''; ?>">
                        <i class="fas fa-history me-2"></i> لاگ‌ها
                    </a>
                    <a href="?page=telegrams" class="sidebar-link <?php echo $current_page == 'telegrams' ? 'active' : ''; ?>">
                        <i class="fab fa-telegram me-2"></i> مدیریت ربات تلگرام
                    </a>
                    <a href="logout.php" class="sidebar-link text-danger mt-5">
                        <i class="fas fa-sign-out-alt me-2"></i> خروج
                    </a>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-10 p-0">
                <!-- Navbar -->
                <nav class="navbar navbar-expand-lg navbar-light">
                    <div class="container-fluid">
                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarNav">
                            <ul class="navbar-nav ms-auto">
                                <li class="nav-item dropdown">
                                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                                        <i class="fas fa-user-circle me-1"></i> <?php echo $_SESSION['admin_username'] ?? 'مدیر'; ?>
                                    </a>
                                    <ul class="dropdown-menu dropdown-menu-end">
                                        <li><a class="dropdown-item" href="?page=profile"><i class="fas fa-user me-2"></i> پروفایل</a></li>
                                        <li><a class="dropdown-item" href="?page=settings"><i class="fas fa-cogs me-2"></i> تنظیمات</a></li>
                                        <li><hr class="dropdown-divider"></li>
                                        <li><a class="dropdown-item text-danger" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i> خروج</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </div>
                    </div>
                </nav>
                
                <!-- Page Content -->
                <div class="main-content">
                    <?php
                    // نمایش محتوای صفحه بر اساس پارامتر page
                    switch ($current_page) {
                        case 'dashboard':
                            include 'pages/dashboard.php';
                            break;
                        case 'users':
                            include 'pages/users.php';
                            break;
                        case 'user_edit':
                            include 'pages/user_edit.php';
                            break;
                        case 'orders':
                            include 'pages/orders.php';
                            break;
                        case 'order_detail':
                            include 'pages/order_detail.php';
                            break;
                        case 'settings':
                            include 'pages/settings.php';
                            break;
                        case 'logs':
                            include 'pages/logs.php';
                            break;
                        case 'telegrams':
                            include 'pages/telegrams.php';
                            break;
                        case 'profile':
                            include 'pages/profile.php';
                            break;
                        default:
                            include 'pages/dashboard.php';
                    }
                    ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap Bundle JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Custom JS -->
    <script>
        $(document).ready(function() {
            // انتخاب تمام چک‌باکس‌ها
            $('#selectAll').change(function() {
                $('.item-checkbox').prop('checked', $(this).prop('checked'));
            });
            
            // آپدیت انتخاب همه بر اساس وضعیت چک‌باکس‌های فردی
            $('.item-checkbox').change(function() {
                var allChecked = true;
                $('.item-checkbox').each(function() {
                    if (!$(this).prop('checked')) {
                        allChecked = false;
                        return false;
                    }
                });
                $('#selectAll').prop('checked', allChecked);
            });
        });
    </script>
</body>
</html>