<?php
/**
 * داشبورد پنل مدیریت
 * 
 * این صفحه آمار و اطلاعات کلی سیستم را نمایش می‌دهد
 */

// دریافت آمار کلی سیستم
$total_users = count_users();
$active_users = 0;
$expired_users = 0;
$total_traffic = 0;

// شمارش کاربران فعال و منقضی شده و محاسبه مصرف کل
$users = get_all_users(1, 1000); // دریافت حداکثر 1000 کاربر
foreach ($users as $user) {
    $is_expired = $user['expiration'] ? (strtotime($user['expiration']) < time()) : false;
    if (!$is_expired && !$user['is_blocked']) {
        $active_users++;
    } else {
        $expired_users++;
    }
    $total_traffic += $user['usage'];
}

// دریافت آمار سفارش‌ها
$order_stats = get_order_statistics('all');
$pending_orders = count_pending_orders();

// دریافت سفارش‌های اخیر
$recent_orders = get_pending_orders(5);

// دریافت فعالیت‌های اخیر کاربران (آخرین اتصالات)
global $pdo;
$stmt = $pdo->prepare("
    SELECT c.*, u.username 
    FROM connection_logs c 
    JOIN users u ON c.user_id = u.id 
    ORDER BY c.connection_time DESC 
    LIMIT 5
");
$stmt->execute();
$recent_connections = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">داشبورد</h1>
    
    <!-- آمار کلی -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="text-primary card-icon"><i class="fas fa-users"></i></div>
                <div class="stat-value"><?php echo $total_users; ?></div>
                <div>تعداد کل کاربران</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="text-success card-icon"><i class="fas fa-user-check"></i></div>
                <div class="stat-value"><?php echo $active_users; ?></div>
                <div>کاربران فعال</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="text-warning card-icon"><i class="fas fa-shopping-cart"></i></div>
                <div class="stat-value"><?php echo $pending_orders; ?></div>
                <div>سفارش‌های در انتظار</div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="dashboard-card">
                <div class="text-info card-icon"><i class="fas fa-database"></i></div>
                <div class="stat-value"><?php echo formatBytes($total_traffic); ?></div>
                <div>کل ترافیک مصرفی</div>
            </div>
        </div>
    </div>
    
    <!-- اطلاعات تکمیلی در دو ستون -->
    <div class="row">
        <!-- سفارش‌های اخیر -->
        <div class="col-lg-6 mb-4">
            <div class="card dashboard-card">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">سفارش‌های اخیر</h6>
                </div>
                <div class="card-body">
                    <?php if (empty($recent_orders)): ?>
                        <p class="text-center text-muted">در حال حاضر سفارش در انتظاری وجود ندارد.</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>شناسه</th>
                                        <th>کاربر</th>
                                        <th>نوع</th>
                                        <th>مبلغ</th>
                                        <th>تاریخ</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_orders as $order): ?>
                                        <tr>
                                            <td><?php echo $order['id']; ?></td>
                                            <td><?php echo htmlspecialchars($order['username']); ?></td>
                                            <td>
                                                <?php
                                                switch ($order['order_type']) {
                                                    case 'new':
                                                        echo '<span class="badge bg-primary">جدید</span>';
                                                        break;
                                                    case 'renewal':
                                                        echo '<span class="badge bg-success">تمدید</span>';
                                                        break;
                                                    case 'upgrade':
                                                        echo '<span class="badge bg-info">ارتقاء</span>';
                                                        break;
                                                }
                                                ?>
                                            </td>
                                            <td><?php echo number_format($order['amount']); ?> تومان</td>
                                            <td><?php echo jdate('Y/m/d H:i', strtotime($order['created_at'])); ?></td>
                                            <td>
                                                <a href="?page=order_detail&id=<?php echo $order['id']; ?>" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center mt-3">
                            <a href="?page=orders" class="btn btn-outline-primary btn-sm">مشاهده همه سفارش‌ها</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- اتصالات اخیر -->
        <div class="col-lg-6 mb-4">
            <div class="card dashboard-card">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">اتصالات اخیر</h6>
                </div>
                <div class="card-body">
                    <?php if (empty($recent_connections)): ?>
                        <p class="text-center text-muted">اطلاعات اتصال اخیری ثبت نشده است.</p>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>کاربر</th>
                                        <th>IP</th>
                                        <th>تاریخ اتصال</th>
                                        <th>وضعیت</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_connections as $connection): ?>
                                        <tr>
                                            <td><?php echo htmlspecialchars($connection['username']); ?></td>
                                            <td><?php echo htmlspecialchars($connection['ip_address']); ?></td>
                                            <td><?php echo jdate('Y/m/d H:i', strtotime($connection['connection_time'])); ?></td>
                                            <td>
                                                <?php
                                                if ($connection['disconnection_time']) {
                                                    echo '<span class="badge bg-secondary">قطع شده</span>';
                                                } else {
                                                    echo '<span class="badge bg-success">فعال</span>';
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                        <div class="text-center mt-3">
                            <a href="?page=logs" class="btn btn-outline-primary btn-sm">مشاهده همه لاگ‌ها</a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- نمودار آمار (اختیاری) -->
    <div class="row">
        <div class="col-12 mb-4">
            <div class="card dashboard-card">
                <div class="card-header bg-white">
                    <h6 class="m-0 font-weight-bold text-primary">آمار سیستم</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h5>آمار کاربران</h5>
                                <div class="progress" style="height: 25px;">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo $total_users ? ($active_users / $total_users * 100) : 0; ?>%">
                                        فعال (<?php echo $active_users; ?>)
                                    </div>
                                    <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo $total_users ? ($expired_users / $total_users * 100) : 0; ?>%">
                                        منقضی (<?php echo $expired_users; ?>)
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-4">
                                <h5>آمار سفارش‌ها</h5>
                                <div class="progress" style="height: 25px;">
                                    <div class="progress-bar bg-success" role="progressbar" style="width: <?php echo $order_stats['total_orders'] ? ($order_stats['completed_orders'] / $order_stats['total_orders'] * 100) : 0; ?>%">
                                        تکمیل شده (<?php echo $order_stats['completed_orders']; ?>)
                                    </div>
                                    <div class="progress-bar bg-warning" role="progressbar" style="width: <?php echo $order_stats['total_orders'] ? ($order_stats['pending_orders'] / $order_stats['total_orders'] * 100) : 0; ?>%">
                                        در انتظار (<?php echo $order_stats['pending_orders']; ?>)
                                    </div>
                                    <div class="progress-bar bg-danger" role="progressbar" style="width: <?php echo $order_stats['total_orders'] ? ($order_stats['rejected_orders'] / $order_stats['total_orders'] * 100) : 0; ?>%">
                                        رد شده (<?php echo $order_stats['rejected_orders']; ?>)
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div> 