<?php
/**
 * صفحه تنظیمات سیستم
 * این صفحه امکان مدیریت تنظیمات مختلف سیستم را فراهم می‌کند
 */

// فایل‌های مورد نیاز را وارد کنید
require_once '../config/settings.php';

// دریافت لیست تنظیمات
$all_settings = get_all_settings();

// گروه‌بندی تنظیمات
$setting_groups = [
    'general' => [],
    'server' => [],
    'telegram' => [],
    'payment' => [],
    'notification' => [],
    'other' => []
];

foreach ($all_settings as $setting) {
    $group = 'other';
    
    if (strpos($setting['key'], 'general_') === 0) {
        $group = 'general';
    } elseif (strpos($setting['key'], 'server_') === 0) {
        $group = 'server';
    } elseif (strpos($setting['key'], 'telegram_') === 0) {
        $group = 'telegram';
    } elseif (strpos($setting['key'], 'payment_') === 0) {
        $group = 'payment';
    } elseif (strpos($setting['key'], 'notification_') === 0) {
        $group = 'notification';
    }
    
    $setting_groups[$group][] = $setting;
}

// ثبت تنظیمات
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['group']) && isset($_POST['settings'])) {
        $group = $_POST['group'];
        $settings = $_POST['settings'];
        $updated_count = 0;
        
        foreach ($settings as $key => $value) {
            // برای فایل‌های آپلود شده مانند لوگو
            if (isset($_FILES['settings']['name'][$key]) && !empty($_FILES['settings']['name'][$key])) {
                $file = $_FILES['settings']['tmp_name'][$key];
                $file_name = $_FILES['settings']['name'][$key];
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));
                
                // بررسی مجاز بودن نوع فایل
                $allowed_extensions = ['jpg', 'jpeg', 'png', 'gif', 'svg'];
                if (in_array($file_ext, $allowed_extensions)) {
                    $upload_dir = '../uploads/';
                    if (!is_dir($upload_dir)) {
                        mkdir($upload_dir, 0755, true);
                    }
                    
                    $new_file_name = 'logo_' . time() . '.' . $file_ext;
                    $upload_path = $upload_dir . $new_file_name;
                    
                    if (move_uploaded_file($file, $upload_path)) {
                        $value = '/uploads/' . $new_file_name;
                        
                        // حذف فایل قدیمی اگر وجود داشته باشد
                        $old_value = get_setting($key);
                        if ($old_value && file_exists('../' . $old_value)) {
                            @unlink('../' . $old_value);
                        }
                    }
                }
            }
            
            if (update_setting($key, $value)) {
                $updated_count++;
            }
        }
        
        // بروزرسانی داده‌های نمایشی
        $all_settings = get_all_settings();
        $setting_groups = [
            'general' => [],
            'server' => [],
            'telegram' => [],
            'payment' => [],
            'notification' => [],
            'other' => []
        ];
        
        foreach ($all_settings as $setting) {
            $group = 'other';
            
            if (strpos($setting['key'], 'general_') === 0) {
                $group = 'general';
            } elseif (strpos($setting['key'], 'server_') === 0) {
                $group = 'server';
            } elseif (strpos($setting['key'], 'telegram_') === 0) {
                $group = 'telegram';
            } elseif (strpos($setting['key'], 'payment_') === 0) {
                $group = 'payment';
            } elseif (strpos($setting['key'], 'notification_') === 0) {
                $group = 'notification';
            }
            
            $setting_groups[$group][] = $setting;
        }
        
        if ($updated_count > 0) {
            $success_message = "تنظیمات با موفقیت بروزرسانی شدند.";
        }
    }
}

// تابع تبدیل کلید تنظیمات به عنوان قابل نمایش
function get_setting_title($key) {
    $key = str_replace(['general_', 'server_', 'telegram_', 'payment_', 'notification_'], '', $key);
    $key = str_replace('_', ' ', $key);
    $key = ucwords($key);
    
    // ترجمه برخی کلیدهای متداول
    $translations = [
        'Site Name' => 'نام سایت',
        'Site Description' => 'توضیحات سایت',
        'Site Logo' => 'لوگوی سایت',
        'Admin Email' => 'ایمیل مدیر',
        'Contact Email' => 'ایمیل تماس',
        'Bot Token' => 'توکن ربات تلگرام',
        'Admin Id' => 'شناسه مدیر در تلگرام',
        'Welcome Message' => 'پیام خوش‌آمدگویی',
        'Help Message' => 'پیام راهنما',
        'Api Key' => 'کلید API',
        'Api Url' => 'آدرس API',
        'Port' => 'پورت',
        'Host' => 'هاست',
        'Username' => 'نام کاربری',
        'Password' => 'رمز عبور',
        'Enable' => 'فعال‌سازی',
        'Enabled' => 'فعال',
        'Disabled' => 'غیرفعال',
        'Default' => 'پیش‌فرض',
        'Config' => 'پیکربندی',
        'Path' => 'مسیر',
        'Gateway' => 'درگاه پرداخت',
        'Merchant Id' => 'شناسه پذیرنده',
        'Callback Url' => 'آدرس بازگشت',
        'Fcm Key' => 'کلید FCM',
    ];
    
    foreach ($translations as $eng => $fa) {
        $key = str_replace($eng, $fa, $key);
    }
    
    return $key;
}

// تابع تعیین نوع فیلد ورودی برای هر تنظیم
function get_setting_input_type($key, $value) {
    // برای تنظیمات فعال/غیرفعال
    if (strpos($key, 'enable_') === 0 || strpos($key, '_enabled') !== false) {
        return 'checkbox';
    }
    
    // برای تنظیمات لوگو یا تصویر
    if (strpos($key, 'logo') !== false || strpos($key, 'image') !== false || strpos($key, 'icon') !== false) {
        return 'file';
    }
    
    // برای پیام‌های طولانی
    if (strpos($key, 'message') !== false || strpos($key, 'description') !== false || strpos($key, 'template') !== false) {
        return 'textarea';
    }
    
    // برای کلیدهای رمزنگاری شده
    if (strpos($key, 'key') !== false || strpos($key, 'secret') !== false || strpos($key, 'password') !== false || strpos($key, 'token') !== false) {
        return 'password';
    }
    
    // برای مقادیر عددی
    if (is_numeric($value) && strpos($value, '.') === false) {
        return 'number';
    }
    
    // پیش‌فرض
    return 'text';
}
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">تنظیمات سیستم</h1>
    
    <?php if (isset($success_message)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $success_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if (isset($error_message)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo $error_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <!-- تب‌های تنظیمات -->
    <div class="card dashboard-card mb-4">
        <div class="card-body">
            <ul class="nav nav-tabs" id="settingsTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">
                        <i class="fas fa-cog"></i> عمومی
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="server-tab" data-bs-toggle="tab" data-bs-target="#server" type="button" role="tab" aria-controls="server" aria-selected="false">
                        <i class="fas fa-server"></i> سرور
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="telegram-tab" data-bs-toggle="tab" data-bs-target="#telegram" type="button" role="tab" aria-controls="telegram" aria-selected="false">
                        <i class="fab fa-telegram"></i> تلگرام
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="payment-tab" data-bs-toggle="tab" data-bs-target="#payment" type="button" role="tab" aria-controls="payment" aria-selected="false">
                        <i class="fas fa-credit-card"></i> پرداخت
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="notification-tab" data-bs-toggle="tab" data-bs-target="#notification" type="button" role="tab" aria-controls="notification" aria-selected="false">
                        <i class="fas fa-bell"></i> اعلان‌ها
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="other-tab" data-bs-toggle="tab" data-bs-target="#other" type="button" role="tab" aria-controls="other" aria-selected="false">
                        <i class="fas fa-ellipsis-h"></i> سایر
                    </button>
                </li>
            </ul>
            
            <div class="tab-content p-3" id="settingsTabsContent">
                <!-- تنظیمات عمومی -->
                <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
                    <form method="post" action="" enctype="multipart/form-data">
                        <input type="hidden" name="group" value="general">
                        
                        <?php if (empty($setting_groups['general'])): ?>
                            <div class="alert alert-info">تنظیمی برای این بخش یافت نشد.</div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($setting_groups['general'] as $setting): ?>
                                    <?php
                                    $input_type = get_setting_input_type($setting['key'], $setting['value']);
                                    $title = get_setting_title($setting['key']);
                                    ?>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="<?php echo $setting['key']; ?>" class="form-label">
                                                <?php echo $title; ?>
                                            </label>
                                            
                                            <?php if ($input_type === 'textarea'): ?>
                                                <textarea class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" rows="3"><?php echo htmlspecialchars($setting['value']); ?></textarea>
                                            
                                            <?php elseif ($input_type === 'checkbox'): ?>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="<?php echo $setting['key']; ?>" 
                                                        name="settings[<?php echo $setting['key']; ?>]" value="1" 
                                                        <?php echo $setting['value'] ? 'checked' : ''; ?>>
                                                </div>
                                            
                                            <?php elseif ($input_type === 'file'): ?>
                                                <input type="file" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]">
                                                
                                                <?php if (!empty($setting['value'])): ?>
                                                    <div class="mt-2">
                                                        <img src="<?php echo $setting['value']; ?>" alt="<?php echo $title; ?>" class="img-thumbnail" style="max-height: 100px;">
                                                        <input type="hidden" name="settings[<?php echo $setting['key']; ?>]" value="<?php echo $setting['value']; ?>">
                                                    </div>
                                                <?php endif; ?>
                                            
                                            <?php else: ?>
                                                <input type="<?php echo $input_type; ?>" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" value="<?php echo htmlspecialchars($setting['value']); ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="text-muted"><?php echo $setting['description']; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
                
                <!-- تنظیمات سرور -->
                <div class="tab-pane fade" id="server" role="tabpanel" aria-labelledby="server-tab">
                    <form method="post" action="">
                        <input type="hidden" name="group" value="server">
                        
                        <?php if (empty($setting_groups['server'])): ?>
                            <div class="alert alert-info">تنظیمی برای این بخش یافت نشد.</div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($setting_groups['server'] as $setting): ?>
                                    <?php
                                    $input_type = get_setting_input_type($setting['key'], $setting['value']);
                                    $title = get_setting_title($setting['key']);
                                    ?>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="<?php echo $setting['key']; ?>" class="form-label">
                                                <?php echo $title; ?>
                                            </label>
                                            
                                            <?php if ($input_type === 'textarea'): ?>
                                                <textarea class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" rows="3"><?php echo htmlspecialchars($setting['value']); ?></textarea>
                                            
                                            <?php elseif ($input_type === 'checkbox'): ?>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="<?php echo $setting['key']; ?>" 
                                                        name="settings[<?php echo $setting['key']; ?>]" value="1" 
                                                        <?php echo $setting['value'] ? 'checked' : ''; ?>>
                                                </div>
                                            
                                            <?php else: ?>
                                                <input type="<?php echo $input_type; ?>" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" value="<?php echo htmlspecialchars($setting['value']); ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="text-muted"><?php echo $setting['description']; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
                
                <!-- تنظیمات تلگرام -->
                <div class="tab-pane fade" id="telegram" role="tabpanel" aria-labelledby="telegram-tab">
                    <form method="post" action="">
                        <input type="hidden" name="group" value="telegram">
                        
                        <?php if (empty($setting_groups['telegram'])): ?>
                            <div class="alert alert-info">تنظیمی برای این بخش یافت نشد.</div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($setting_groups['telegram'] as $setting): ?>
                                    <?php
                                    $input_type = get_setting_input_type($setting['key'], $setting['value']);
                                    $title = get_setting_title($setting['key']);
                                    ?>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="<?php echo $setting['key']; ?>" class="form-label">
                                                <?php echo $title; ?>
                                            </label>
                                            
                                            <?php if ($input_type === 'textarea'): ?>
                                                <textarea class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" rows="3"><?php echo htmlspecialchars($setting['value']); ?></textarea>
                                            
                                            <?php elseif ($input_type === 'checkbox'): ?>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="<?php echo $setting['key']; ?>" 
                                                        name="settings[<?php echo $setting['key']; ?>]" value="1" 
                                                        <?php echo $setting['value'] ? 'checked' : ''; ?>>
                                                </div>
                                            
                                            <?php else: ?>
                                                <input type="<?php echo $input_type; ?>" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" value="<?php echo htmlspecialchars($setting['value']); ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="text-muted"><?php echo $setting['description']; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تنظیمات
                                </button>
                                
                                <a href="/telegram/set_webhook.php" class="btn btn-info ms-2" target="_blank">
                                    <i class="fas fa-sync"></i> تنظیم مجدد وب‌هوک
                                </a>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
                
                <!-- تنظیمات پرداخت -->
                <div class="tab-pane fade" id="payment" role="tabpanel" aria-labelledby="payment-tab">
                    <form method="post" action="">
                        <input type="hidden" name="group" value="payment">
                        
                        <?php if (empty($setting_groups['payment'])): ?>
                            <div class="alert alert-info">تنظیمی برای این بخش یافت نشد.</div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($setting_groups['payment'] as $setting): ?>
                                    <?php
                                    $input_type = get_setting_input_type($setting['key'], $setting['value']);
                                    $title = get_setting_title($setting['key']);
                                    ?>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="<?php echo $setting['key']; ?>" class="form-label">
                                                <?php echo $title; ?>
                                            </label>
                                            
                                            <?php if ($input_type === 'textarea'): ?>
                                                <textarea class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" rows="3"><?php echo htmlspecialchars($setting['value']); ?></textarea>
                                            
                                            <?php elseif ($input_type === 'checkbox'): ?>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="<?php echo $setting['key']; ?>" 
                                                        name="settings[<?php echo $setting['key']; ?>]" value="1" 
                                                        <?php echo $setting['value'] ? 'checked' : ''; ?>>
                                                </div>
                                            
                                            <?php else: ?>
                                                <input type="<?php echo $input_type; ?>" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" value="<?php echo htmlspecialchars($setting['value']); ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="text-muted"><?php echo $setting['description']; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
                
                <!-- تنظیمات اعلان‌ها -->
                <div class="tab-pane fade" id="notification" role="tabpanel" aria-labelledby="notification-tab">
                    <form method="post" action="">
                        <input type="hidden" name="group" value="notification">
                        
                        <?php if (empty($setting_groups['notification'])): ?>
                            <div class="alert alert-info">تنظیمی برای این بخش یافت نشد.</div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($setting_groups['notification'] as $setting): ?>
                                    <?php
                                    $input_type = get_setting_input_type($setting['key'], $setting['value']);
                                    $title = get_setting_title($setting['key']);
                                    ?>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="<?php echo $setting['key']; ?>" class="form-label">
                                                <?php echo $title; ?>
                                            </label>
                                            
                                            <?php if ($input_type === 'textarea'): ?>
                                                <textarea class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" rows="3"><?php echo htmlspecialchars($setting['value']); ?></textarea>
                                            
                                            <?php elseif ($input_type === 'checkbox'): ?>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="<?php echo $setting['key']; ?>" 
                                                        name="settings[<?php echo $setting['key']; ?>]" value="1" 
                                                        <?php echo $setting['value'] ? 'checked' : ''; ?>>
                                                </div>
                                            
                                            <?php else: ?>
                                                <input type="<?php echo $input_type; ?>" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" value="<?php echo htmlspecialchars($setting['value']); ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="text-muted"><?php echo $setting['description']; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
                
                <!-- سایر تنظیمات -->
                <div class="tab-pane fade" id="other" role="tabpanel" aria-labelledby="other-tab">
                    <form method="post" action="">
                        <input type="hidden" name="group" value="other">
                        
                        <?php if (empty($setting_groups['other'])): ?>
                            <div class="alert alert-info">تنظیمی برای این بخش یافت نشد.</div>
                        <?php else: ?>
                            <div class="row">
                                <?php foreach ($setting_groups['other'] as $setting): ?>
                                    <?php
                                    $input_type = get_setting_input_type($setting['key'], $setting['value']);
                                    $title = get_setting_title($setting['key']);
                                    ?>
                                    
                                    <div class="col-md-6 mb-3">
                                        <div class="form-group">
                                            <label for="<?php echo $setting['key']; ?>" class="form-label">
                                                <?php echo $title; ?>
                                            </label>
                                            
                                            <?php if ($input_type === 'textarea'): ?>
                                                <textarea class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" rows="3"><?php echo htmlspecialchars($setting['value']); ?></textarea>
                                            
                                            <?php elseif ($input_type === 'checkbox'): ?>
                                                <div class="form-check form-switch">
                                                    <input class="form-check-input" type="checkbox" id="<?php echo $setting['key']; ?>" 
                                                        name="settings[<?php echo $setting['key']; ?>]" value="1" 
                                                        <?php echo $setting['value'] ? 'checked' : ''; ?>>
                                                </div>
                                            
                                            <?php else: ?>
                                                <input type="<?php echo $input_type; ?>" class="form-control" id="<?php echo $setting['key']; ?>" 
                                                    name="settings[<?php echo $setting['key']; ?>]" value="<?php echo htmlspecialchars($setting['value']); ?>">
                                            <?php endif; ?>
                                            
                                            <?php if (!empty($setting['description'])): ?>
                                                <small class="text-muted"><?php echo $setting['description']; ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            
                            <div class="text-end mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> ذخیره تنظیمات
                                </button>
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>
    </div>
    
    <!-- کارت افزودن تنظیم جدید -->
    <div class="card dashboard-card">
        <div class="card-header">
            <h5 class="mb-0">افزودن تنظیم جدید</h5>
        </div>
        <div class="card-body">
            <form method="post" action="">
                <input type="hidden" name="action" value="add_setting">
                
                <div class="row">
                    <div class="col-md-4 mb-3">
                        <label for="new_key" class="form-label">کلید</label>
                        <input type="text" class="form-control" id="new_key" name="new_key" required>
                        <small class="text-muted">برای دسته‌بندی از پیشوند استفاده کنید. مثال: general_site_name</small>
                    </div>
                    
                    <div class="col-md-4 mb-3">
                        <label for="new_value" class="form-label">مقدار</label>
                        <input type="text" class="form-control" id="new_value" name="new_value">
                    </div>
                    
                    <div class="col-md-4 mb-3">
                        <label for="new_description" class="form-label">توضیحات (اختیاری)</label>
                        <input type="text" class="form-control" id="new_description" name="new_description">
                    </div>
                </div>
                
                <div class="text-end">
                    <button type="submit" class="btn btn-success">
                        <i class="fas fa-plus"></i> افزودن تنظیم
                    </button>
                </div>
            </form>
        </div>
    </div>
</div> 