<?php
/**
 * صفحه ویرایش اطلاعات کاربر
 * این صفحه امکان ویرایش کامل اطلاعات کاربر، مدیریت دستگاه‌ها و مشاهده آمار مصرف را فراهم می‌کند
 */

// بررسی وجود شناسه کاربر
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    echo '<div class="alert alert-danger">کاربر مورد نظر یافت نشد.</div>';
    echo '<a href="?page=users" class="btn btn-primary">بازگشت به لیست کاربران</a>';
    exit;
}

$user_id = (int)$_GET['id'];
$user = get_user($user_id);

// بررسی وجود کاربر
if (!$user) {
    echo '<div class="alert alert-danger">کاربر مورد نظر یافت نشد.</div>';
    echo '<a href="?page=users" class="btn btn-primary">بازگشت به لیست کاربران</a>';
    exit;
}

// بررسی ارسال فرم
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];
        
        // ویرایش اطلاعات کاربر
        if ($action === 'update_user') {
            $update_data = [
                'username' => $_POST['username'] ?? $user['username'],
                'email' => $_POST['email'] ?? null,
                'telegram_id' => $_POST['telegram_id'] ?? null,
                'is_blocked' => isset($_POST['is_blocked']) ? 1 : 0,
                'max_devices' => $_POST['max_devices'] ?? 1,
            ];
            
            // بررسی رمز عبور
            if (!empty($_POST['password'])) {
                $update_data['password'] = $_POST['password'];
            }
            
            // تاریخ انقضا
            if (!empty($_POST['expiration'])) {
                $update_data['expiration'] = $_POST['expiration'];
            } else {
                $update_data['expiration'] = null; // نامحدود
            }
            
            // حجم اشتراک
            if (isset($_POST['quota']) && is_numeric($_POST['quota'])) {
                $update_data['quota'] = (int)$_POST['quota'] * 1073741824; // تبدیل GB به بایت
            } else {
                $update_data['quota'] = 0; // نامحدود
            }
            
            // بروزرسانی اطلاعات کاربر
            if (update_user($user_id, $update_data)) {
                $success_message = "اطلاعات کاربر با موفقیت بروزرسانی شد.";
                // دریافت اطلاعات کاربر بعد از بروزرسانی
                $user = get_user($user_id);
            } else {
                $error_message = "خطا در بروزرسانی اطلاعات کاربر.";
            }
        }
        
        // ریست مصرف
        if ($action === 'reset_usage') {
            global $pdo;
            try {
                $stmt = $pdo->prepare("UPDATE users SET usage = 0 WHERE id = ?");
                $stmt->execute([$user_id]);
                
                if ($stmt->rowCount() > 0) {
                    $success_message = "مصرف کاربر با موفقیت ریست شد.";
                    // بروزرسانی اطلاعات کاربر
                    $user = get_user($user_id);
                } else {
                    $error_message = "خطا در ریست مصرف کاربر.";
                }
            } catch (PDOException $e) {
                $error_message = "خطا در ریست مصرف کاربر: " . $e->getMessage();
            }
        }
        
        // حذف دستگاه
        if ($action === 'delete_device' && isset($_POST['device_id'])) {
            $device_id = $_POST['device_id'];
            
            global $pdo;
            try {
                $stmt = $pdo->prepare("DELETE FROM user_devices WHERE id = ? AND user_id = ?");
                $stmt->execute([$device_id, $user_id]);
                
                if ($stmt->rowCount() > 0) {
                    $success_message = "دستگاه با موفقیت حذف شد.";
                    // بروزرسانی تعداد دستگاه‌های فعال
                    $stmt = $pdo->prepare("UPDATE users SET active_devices = active_devices - 1 WHERE id = ? AND active_devices > 0");
                    $stmt->execute([$user_id]);
                } else {
                    $error_message = "خطا در حذف دستگاه.";
                }
            } catch (PDOException $e) {
                $error_message = "خطا در حذف دستگاه: " . $e->getMessage();
            }
        }
    }
}

// دریافت دستگاه‌های کاربر
global $pdo;
$stmt = $pdo->prepare("SELECT * FROM user_devices WHERE user_id = ? ORDER BY last_connection DESC");
$stmt->execute([$user_id]);
$devices = $stmt->fetchAll(PDO::FETCH_ASSOC);

// دریافت تاریخچه اتصالات کاربر
$stmt = $pdo->prepare("
    SELECT * FROM connection_logs 
    WHERE user_id = ? 
    ORDER BY connection_time DESC 
    LIMIT 20
");
$stmt->execute([$user_id]);
$connections = $stmt->fetchAll(PDO::FETCH_ASSOC);

// بررسی وضعیت کاربر
$is_expired = $user['expiration'] ? (strtotime($user['expiration']) < time()) : false;
$is_blocked = $user['is_blocked'] == 1;
$usage_percentage = $user['quota'] > 0 ? min(round(($user['usage'] / $user['quota']) * 100), 100) : 0;
$status_class = $is_blocked ? 'danger' : ($is_expired ? 'warning' : 'success');
$status_text = $is_blocked ? 'مسدود' : ($is_expired ? 'منقضی شده' : 'فعال');

// محاسبه روزهای باقیمانده
$days_left = 0;
if ($user['expiration']) {
    $days_left = ceil((strtotime($user['expiration']) - time()) / 86400);
}
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            ویرایش کاربر: <?php echo htmlspecialchars($user['username']); ?>
        </h1>
        <a href="?page=users" class="btn btn-outline-primary">بازگشت به لیست کاربران</a>
    </div>
    
    <?php if (isset($success_message)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $success_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if (isset($error_message)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo $error_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <div class="row">
        <!-- اطلاعات کاربر -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card dashboard-card h-100">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">اطلاعات کاربر</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12 mb-2">
                            <span class="badge bg-<?php echo $status_class; ?> fs-6 mb-2">
                                <i class="fas fa-user me-1"></i> <?php echo $status_text; ?>
                            </span>
                        </div>
                        
                        <div class="col-lg-6 mb-2">
                            <div class="text-sm text-muted">شناسه کاربر:</div>
                            <div class="fw-bold"><?php echo $user['id']; ?></div>
                        </div>
                        
                        <div class="col-lg-6 mb-2">
                            <div class="text-sm text-muted">نام کاربری:</div>
                            <div class="fw-bold"><?php echo htmlspecialchars($user['username']); ?></div>
                        </div>
                        
                        <div class="col-lg-6 mb-2">
                            <div class="text-sm text-muted">تاریخ ثبت‌نام:</div>
                            <div class="fw-bold"><?php echo jdate('Y/m/d H:i', strtotime($user['created_at'])); ?></div>
                        </div>
                        
                        <div class="col-lg-6 mb-2">
                            <div class="text-sm text-muted">آخرین بروزرسانی:</div>
                            <div class="fw-bold"><?php echo jdate('Y/m/d H:i', strtotime($user['updated_at'])); ?></div>
                        </div>
                        
                        <div class="col-lg-12 mb-2">
                            <div class="text-sm text-muted">ایمیل:</div>
                            <div class="fw-bold"><?php echo $user['email'] ? htmlspecialchars($user['email']) : '<span class="text-muted">ثبت نشده</span>'; ?></div>
                        </div>
                        
                        <div class="col-lg-12 mb-2">
                            <div class="text-sm text-muted">شناسه تلگرام:</div>
                            <div class="fw-bold"><?php echo $user['telegram_id'] ? htmlspecialchars($user['telegram_id']) : '<span class="text-muted">ثبت نشده</span>'; ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- وضعیت اشتراک -->
        <div class="col-xl-4 col-md-6 mb-4">
            <div class="card dashboard-card h-100">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">وضعیت اشتراک</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="text-sm text-muted">تاریخ انقضا:</div>
                        <div class="fw-bold fs-5">
                            <?php if ($user['expiration']): ?>
                                <?php echo jdate('Y/m/d', strtotime($user['expiration'])); ?>
                                <small class="text-<?php echo $days_left > 0 ? 'success' : 'danger'; ?>">
                                    (<?php echo $days_left > 0 ? $days_left . ' روز باقیمانده' : 'منقضی شده'; ?>)
                                </small>
                            <?php else: ?>
                                <span class="text-success">بدون محدودیت زمانی</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="text-sm text-muted">حجم اشتراک:</div>
                        <div class="fw-bold">
                            <?php if ($user['quota'] > 0): ?>
                                <?php echo formatBytes($user['quota']); ?>
                            <?php else: ?>
                                <span class="text-success">بدون محدودیت حجم</span>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="text-sm text-muted">مصرف:</div>
                        <?php if ($user['quota'] > 0): ?>
                            <div class="progress mb-2" style="height: 10px;">
                                <div class="progress-bar bg-<?php echo $usage_percentage > 90 ? 'danger' : ($usage_percentage > 70 ? 'warning' : 'success'); ?>" 
                                     role="progressbar" style="width: <?php echo $usage_percentage; ?>%"></div>
                            </div>
                            <div class="fw-bold">
                                <?php echo formatBytes($user['usage']); ?> از <?php echo formatBytes($user['quota']); ?>
                                (<?php echo $usage_percentage; ?>%)
                            </div>
                        <?php else: ?>
                            <div class="fw-bold"><?php echo formatBytes($user['usage']); ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="mb-3">
                        <div class="text-sm text-muted">دستگاه‌های فعال:</div>
                        <div class="fw-bold">
                            <?php echo $user['active_devices']; ?> از <?php echo $user['max_devices']; ?> دستگاه
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <form method="post" action="" onsubmit="return confirm('آیا از ریست کردن حجم مصرفی کاربر اطمینان دارید؟');">
                            <input type="hidden" name="action" value="reset_usage">
                            <button type="submit" class="btn btn-warning btn-sm">
                                <i class="fas fa-redo"></i> ریست مصرف
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- لینک‌های اشتراک -->
        <div class="col-xl-4 col-md-12 mb-4">
            <div class="card dashboard-card h-100">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">لینک‌های اشتراک</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="text-sm text-muted mb-2">لینک اشتراک:</div>
                        <div class="input-group">
                            <input type="text" class="form-control subscription-link" value="<?php echo htmlspecialchars(get_subscription_link($user['id'])); ?>" readonly>
                            <button class="btn btn-outline-primary copy-btn" type="button" data-clipboard-target=".subscription-link">
                                <i class="fas fa-copy"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <div class="text-sm text-muted mb-2">QR کد:</div>
                        <div class="text-center">
                            <img src="https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=<?php echo urlencode(get_subscription_link($user['id'])); ?>" alt="QR Code" class="img-fluid">
                        </div>
                    </div>
                    
                    <div class="d-grid gap-2 mt-3">
                        <button class="btn btn-sm btn-outline-primary" type="button" onclick="window.open('<?php echo htmlspecialchars(get_subscription_link($user['id'])); ?>', '_blank')">
                            <i class="fas fa-external-link-alt"></i> بازکردن لینک اشتراک
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row">
        <!-- ویرایش اطلاعات کاربر -->
        <div class="col-lg-6 mb-4">
            <div class="card dashboard-card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">ویرایش اطلاعات کاربر</h6>
                </div>
                <div class="card-body">
                    <form method="post" action="">
                        <input type="hidden" name="action" value="update_user">
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="username" class="form-label">نام کاربری:</label>
                                <input type="text" id="username" name="username" class="form-control" value="<?php echo htmlspecialchars($user['username']); ?>" required>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="password" class="form-label">رمز عبور: <small class="text-muted">(برای عدم تغییر خالی بگذارید)</small></label>
                                <div class="input-group">
                                    <input type="text" id="password" name="password" class="form-control">
                                    <button class="btn btn-outline-secondary" type="button" onclick="generatePassword()">تصادفی</button>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="email" class="form-label">ایمیل:</label>
                                <input type="email" id="email" name="email" class="form-control" value="<?php echo htmlspecialchars($user['email'] ?? ''); ?>">
                            </div>
                            
                            <div class="col-md-6">
                                <label for="telegram_id" class="form-label">شناسه تلگرام:</label>
                                <input type="text" id="telegram_id" name="telegram_id" class="form-control" value="<?php echo htmlspecialchars($user['telegram_id'] ?? ''); ?>">
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="expiration" class="form-label">تاریخ انقضا:</label>
                                <input type="date" id="expiration" name="expiration" class="form-control" 
                                    value="<?php echo $user['expiration'] ? date('Y-m-d', strtotime($user['expiration'])) : ''; ?>">
                                <small class="text-muted">خالی بگذارید برای اشتراک نامحدود</small>
                            </div>
                            
                            <div class="col-md-6">
                                <label for="quota" class="form-label">حجم اشتراک (گیگابایت):</label>
                                <input type="number" id="quota" name="quota" class="form-control" min="0" 
                                    value="<?php echo $user['quota'] > 0 ? round($user['quota'] / 1073741824) : 0; ?>">
                                <small class="text-muted">0 بگذارید برای حجم نامحدود</small>
                            </div>
                        </div>
                        
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="max_devices" class="form-label">حداکثر دستگاه‌ها:</label>
                                <input type="number" id="max_devices" name="max_devices" class="form-control" min="1" 
                                    value="<?php echo $user['max_devices']; ?>">
                            </div>
                            
                            <div class="col-md-6">
                                <label class="form-label d-block">وضعیت کاربر:</label>
                                <div class="form-check form-switch mt-2">
                                    <input class="form-check-input" type="checkbox" id="is_blocked" name="is_blocked" value="1" 
                                        <?php echo $user['is_blocked'] ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="is_blocked">کاربر مسدود شود</label>
                                </div>
                            </div>
                        </div>
                        
                        <div class="text-end mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> ذخیره تغییرات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        
        <!-- دستگاه‌های کاربر -->
        <div class="col-lg-6 mb-4">
            <div class="card dashboard-card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">دستگاه‌های کاربر</h6>
                </div>
                <div class="card-body">
                    <?php if (empty($devices)): ?>
                        <div class="alert alert-info">این کاربر هنوز از هیچ دستگاهی استفاده نکرده است.</div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>شناسه دستگاه</th>
                                        <th>نام دستگاه</th>
                                        <th>آخرین اتصال</th>
                                        <th>IP</th>
                                        <th>عملیات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($devices as $device): ?>
                                        <tr>
                                            <td><?php echo $device['id']; ?></td>
                                            <td><?php echo htmlspecialchars($device['device_name']); ?></td>
                                            <td>
                                                <?php
                                                if ($device['last_connection']) {
                                                    echo jdate('Y/m/d H:i', strtotime($device['last_connection']));
                                                } else {
                                                    echo '<span class="text-muted">-</span>';
                                                }
                                                ?>
                                            </td>
                                            <td><?php echo htmlspecialchars($device['ip_address'] ?? '-'); ?></td>
                                            <td>
                                                <form method="post" action="" onsubmit="return confirm('آیا از حذف این دستگاه اطمینان دارید؟');">
                                                    <input type="hidden" name="action" value="delete_device">
                                                    <input type="hidden" name="device_id" value="<?php echo $device['id']; ?>">
                                                    <button type="submit" class="btn btn-danger btn-sm">
                                                        <i class="fas fa-trash"></i> حذف
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- تاریخچه اتصالات -->
    <div class="row">
        <div class="col-lg-12 mb-4">
            <div class="card dashboard-card">
                <div class="card-header">
                    <h6 class="m-0 font-weight-bold text-primary">تاریخچه اتصالات</h6>
                </div>
                <div class="card-body">
                    <?php if (empty($connections)): ?>
                        <div class="alert alert-info">تاریخچه اتصالی برای این کاربر ثبت نشده است.</div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>زمان اتصال</th>
                                        <th>زمان قطع</th>
                                        <th>مدت اتصال</th>
                                        <th>IP</th>
                                        <th>حجم مصرفی</th>
                                        <th>وضعیت</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($connections as $conn): ?>
                                        <?php
                                        // محاسبه مدت زمان اتصال
                                        $duration = '-';
                                        if ($conn['disconnection_time']) {
                                            $start = strtotime($conn['connection_time']);
                                            $end = strtotime($conn['disconnection_time']);
                                            $diff_seconds = $end - $start;
                                            
                                            if ($diff_seconds < 60) {
                                                $duration = $diff_seconds . ' ثانیه';
                                            } elseif ($diff_seconds < 3600) {
                                                $duration = floor($diff_seconds / 60) . ' دقیقه';
                                            } else {
                                                $hours = floor($diff_seconds / 3600);
                                                $minutes = floor(($diff_seconds % 3600) / 60);
                                                $duration = $hours . ' ساعت و ' . $minutes . ' دقیقه';
                                            }
                                        }
                                        ?>
                                        <tr>
                                            <td><?php echo jdate('Y/m/d H:i:s', strtotime($conn['connection_time'])); ?></td>
                                            <td>
                                                <?php
                                                if ($conn['disconnection_time']) {
                                                    echo jdate('Y/m/d H:i:s', strtotime($conn['disconnection_time']));
                                                } else {
                                                    echo '<span class="badge bg-success">در حال اتصال</span>';
                                                }
                                                ?>
                                            </td>
                                            <td><?php echo $duration; ?></td>
                                            <td><?php echo htmlspecialchars($conn['ip_address']); ?></td>
                                            <td><?php echo formatBytes($conn['data_used']); ?></td>
                                            <td>
                                                <?php
                                                if (!$conn['disconnection_time']) {
                                                    echo '<span class="badge bg-success">فعال</span>';
                                                } elseif ($conn['disconnection_reason']) {
                                                    echo '<span class="badge bg-warning" title="' . htmlspecialchars($conn['disconnection_reason']) . '">قطع با خطا</span>';
                                                } else {
                                                    echo '<span class="badge bg-secondary">قطع عادی</span>';
                                                }
                                                ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// ایجاد رمز عبور تصادفی
function generatePassword() {
    const chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    let password = '';
    for (let i = 0; i < 8; i++) {
        password += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById('password').value = password;
}

// کپی کردن لینک اشتراک
document.addEventListener('DOMContentLoaded', function() {
    var clipboard = new ClipboardJS('.copy-btn');
    
    clipboard.on('success', function(e) {
        e.trigger.innerHTML = '<i class="fas fa-check"></i>';
        setTimeout(function() {
            e.trigger.innerHTML = '<i class="fas fa-copy"></i>';
        }, 2000);
    });
});
</script> 