<?php
/**
 * صفحه مدیریت کاربران
 * این صفحه امکان مدیریت کاربران، جستجو، فیلتر و ویرایش آنها را فراهم می‌کند
 */

// انجام عملیات درخواستی
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // عملیات حذف کاربران
    if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['user_ids'])) {
        $user_ids = $_POST['user_ids'];
        $deleted_count = 0;
        
        global $pdo;
        foreach ($user_ids as $user_id) {
            try {
                $stmt = $pdo->prepare("DELETE FROM users WHERE id = ?");
                $stmt->execute([$user_id]);
                if ($stmt->rowCount() > 0) {
                    $deleted_count++;
                }
            } catch (PDOException $e) {
                // خطا در حذف کاربر
            }
        }
        
        $success_message = "{$deleted_count} کاربر با موفقیت حذف شد.";
    }
    
    // عملیات مسدود/آزاد کردن کاربران
    if (isset($_POST['action']) && ($_POST['action'] === 'block' || $_POST['action'] === 'unblock') && isset($_POST['user_ids'])) {
        $user_ids = $_POST['user_ids'];
        $is_blocked = ($_POST['action'] === 'block') ? 1 : 0;
        $updated_count = 0;
        
        global $pdo;
        foreach ($user_ids as $user_id) {
            try {
                $stmt = $pdo->prepare("UPDATE users SET is_blocked = ? WHERE id = ?");
                $stmt->execute([$is_blocked, $user_id]);
                if ($stmt->rowCount() > 0) {
                    $updated_count++;
                }
            } catch (PDOException $e) {
                // خطا در بروزرسانی وضعیت کاربر
            }
        }
        
        $success_message = "{$updated_count} کاربر با موفقیت " . ($is_blocked ? "مسدود" : "آزاد") . " شد.";
    }
    
    // ایجاد کاربر جدید
    if (isset($_POST['action']) && $_POST['action'] === 'create') {
        $username = $_POST['username'] ?? '';
        $password = $_POST['password'] ?? '';
        $email = $_POST['email'] ?? null;
        $telegram_id = $_POST['telegram_id'] ?? null;
        $expiration = !empty($_POST['expiration']) ? $_POST['expiration'] : null;
        $quota = !empty($_POST['quota']) ? (int)$_POST['quota'] * 1073741824 : 0; // تبدیل GB به بایت
        $max_devices = $_POST['max_devices'] ?? 1;
        
        if (!empty($username) && !empty($password)) {
            $user_id = create_user($username, $password, $email, $telegram_id);
            
            if ($user_id) {
                // بروزرسانی اطلاعات اضافی کاربر
                $update_data = [
                    'expiration' => $expiration,
                    'quota' => $quota,
                    'max_devices' => $max_devices
                ];
                
                update_user($user_id, $update_data);
                $success_message = "کاربر جدید با موفقیت ایجاد شد.";
            } else {
                $error_message = "خطا در ایجاد کاربر. احتمالاً نام کاربری تکراری است.";
            }
        } else {
            $error_message = "لطفاً نام کاربری و رمز عبور را وارد کنید.";
        }
    }
}

// تنظیمات صفحه‌بندی
$page = isset($_GET['page_num']) ? (int)$_GET['page_num'] : 1;
$per_page = 15;

// فیلترهای جستجو
$search = isset($_GET['search']) ? $_GET['search'] : '';
$filter_status = isset($_GET['status']) ? $_GET['status'] : '';

// دریافت لیست کاربران
$where_clauses = [];
$params = [];

if (!empty($search)) {
    $where_clauses[] = "(username LIKE ? OR email LIKE ?)";
    $params[] = "%{$search}%";
    $params[] = "%{$search}%";
}

if ($filter_status === 'active') {
    $where_clauses[] = "is_blocked = 0 AND (expiration IS NULL OR expiration > NOW())";
} elseif ($filter_status === 'expired') {
    $where_clauses[] = "expiration IS NOT NULL AND expiration <= NOW()";
} elseif ($filter_status === 'blocked') {
    $where_clauses[] = "is_blocked = 1";
}

// ساخت کوئری
$sql = "SELECT * FROM users";
if (!empty($where_clauses)) {
    $sql .= " WHERE " . implode(" AND ", $where_clauses);
}
$sql .= " ORDER BY id DESC LIMIT ? OFFSET ?";
$params[] = $per_page;
$params[] = ($page - 1) * $per_page;

// اجرای کوئری
global $pdo;
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);

// دریافت تعداد کل کاربران برای صفحه‌بندی
$count_sql = "SELECT COUNT(*) FROM users";
if (!empty($where_clauses)) {
    $count_sql .= " WHERE " . implode(" AND ", $where_clauses);
}
$count_stmt = $pdo->prepare($count_sql);
$count_stmt->execute(array_slice($params, 0, -2));
$total_users = $count_stmt->fetchColumn();

$total_pages = ceil($total_users / $per_page);
?>

<div class="container-fluid">
    <h1 class="h3 mb-4 text-gray-800">مدیریت کاربران</h1>
    
    <?php if (isset($success_message)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $success_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if (isset($error_message)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?php echo $error_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <!-- کارت فیلتر و جستجو -->
    <div class="card dashboard-card mb-4">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <form action="" method="get">
                        <input type="hidden" name="page" value="users">
                        <div class="input-group">
                            <input type="text" class="form-control" placeholder="جستجو..." name="search" value="<?php echo htmlspecialchars($search); ?>">
                            <select class="form-select" name="status">
                                <option value="" <?php echo $filter_status === '' ? 'selected' : ''; ?>>همه وضعیت‌ها</option>
                                <option value="active" <?php echo $filter_status === 'active' ? 'selected' : ''; ?>>فعال</option>
                                <option value="expired" <?php echo $filter_status === 'expired' ? 'selected' : ''; ?>>منقضی شده</option>
                                <option value="blocked" <?php echo $filter_status === 'blocked' ? 'selected' : ''; ?>>مسدود شده</option>
                            </select>
                            <button class="btn btn-primary" type="submit">
                                <i class="fas fa-search"></i>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="col-md-6 text-end">
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#createUserModal">
                        <i class="fas fa-user-plus"></i> ایجاد کاربر جدید
                    </button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- جدول کاربران -->
    <div class="card dashboard-card">
        <div class="card-body">
            <form action="" method="post" id="userActionForm">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover table-striped">
                        <thead>
                            <tr>
                                <th>
                                    <input type="checkbox" id="selectAll">
                                </th>
                                <th>#</th>
                                <th>نام کاربری</th>
                                <th>تاریخ انقضا</th>
                                <th>مصرف</th>
                                <th>دستگاه‌ها</th>
                                <th>وضعیت</th>
                                <th>عملیات</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($users)): ?>
                                <tr>
                                    <td colspan="8" class="text-center">کاربری یافت نشد.</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($users as $user): ?>
                                    <?php
                                    $is_expired = $user['expiration'] ? (strtotime($user['expiration']) < time()) : false;
                                    $usage_percentage = $user['quota'] > 0 ? min(round(($user['usage'] / $user['quota']) * 100), 100) : 0;
                                    $status_class = $user['is_blocked'] ? 'danger' : ($is_expired ? 'warning' : 'success');
                                    $status_text = $user['is_blocked'] ? 'مسدود' : ($is_expired ? 'منقضی شده' : 'فعال');
                                    ?>
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="user_ids[]" value="<?php echo $user['id']; ?>" class="item-checkbox">
                                        </td>
                                        <td><?php echo $user['id']; ?></td>
                                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                                        <td>
                                            <?php
                                            if ($user['expiration']) {
                                                echo jdate('Y/m/d', strtotime($user['expiration']));
                                                $days_left = ceil((strtotime($user['expiration']) - time()) / 86400);
                                                if ($days_left > 0) {
                                                    echo " ({$days_left} روز)";
                                                } else {
                                                    echo " (منقضی شده)";
                                                }
                                            } else {
                                                echo 'نامحدود';
                                            }
                                            ?>
                                        </td>
                                        <td>
                                            <?php if ($user['quota'] > 0): ?>
                                                <div class="progress mb-1" style="height: 10px;">
                                                    <div class="progress-bar bg-<?php echo $usage_percentage > 90 ? 'danger' : ($usage_percentage > 70 ? 'warning' : 'success'); ?>" 
                                                        role="progressbar" style="width: <?php echo $usage_percentage; ?>%"></div>
                                                </div>
                                                <?php echo formatBytes($user['usage']); ?> / <?php echo formatBytes($user['quota']); ?>
                                                (<?php echo $usage_percentage; ?>%)
                                            <?php else: ?>
                                                <?php echo formatBytes($user['usage']); ?> / ∞
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo $user['active_devices']; ?> / <?php echo $user['max_devices']; ?></td>
                                        <td>
                                            <span class="badge bg-<?php echo $status_class; ?>">
                                                <?php echo $status_text; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <a href="?page=user_edit&id=<?php echo $user['id']; ?>" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger" 
                                                onclick="deleteUser(<?php echo $user['id']; ?>, '<?php echo htmlspecialchars($user['username']); ?>')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                
                <!-- گزینه‌های انتخاب شده -->
                <div class="row mt-3">
                    <div class="col">
                        <div class="btn-group">
                            <button type="button" class="btn btn-outline-primary dropdown-toggle" data-bs-toggle="dropdown">
                                عملیات گروهی
                            </button>
                            <div class="dropdown-menu">
                                <button type="submit" class="dropdown-item" name="action" value="block" onclick="return confirm('آیا از مسدود کردن کاربران انتخاب شده اطمینان دارید؟')">مسدود کردن</button>
                                <button type="submit" class="dropdown-item" name="action" value="unblock">آزاد کردن</button>
                                <div class="dropdown-divider"></div>
                                <button type="submit" class="dropdown-item text-danger" name="action" value="delete" 
                                    onclick="return confirm('آیا از حذف کاربران انتخاب شده اطمینان دارید؟ این عمل غیرقابل بازگشت است!')">
                                    حذف کاربران
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
            
            <!-- صفحه‌بندی -->
            <?php if ($total_pages > 1): ?>
                <nav aria-label="Page navigation" class="mt-4">
                    <ul class="pagination justify-content-center">
                        <?php if ($page > 1): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=users&page_num=<?php echo $page - 1; ?>&search=<?php echo urlencode($search); ?>&status=<?php echo $filter_status; ?>">
                                    قبلی
                                </a>
                            </li>
                        <?php endif; ?>
                        
                        <?php for ($i = max(1, $page - 2); $i <= min($total_pages, $page + 2); $i++): ?>
                            <li class="page-item <?php echo $i === $page ? 'active' : ''; ?>">
                                <a class="page-link" href="?page=users&page_num=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&status=<?php echo $filter_status; ?>">
                                    <?php echo $i; ?>
                                </a>
                            </li>
                        <?php endfor; ?>
                        
                        <?php if ($page < $total_pages): ?>
                            <li class="page-item">
                                <a class="page-link" href="?page=users&page_num=<?php echo $page + 1; ?>&search=<?php echo urlencode($search); ?>&status=<?php echo $filter_status; ?>">
                                    بعدی
                                </a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </nav>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- مودال ایجاد کاربر جدید -->
<div class="modal fade" id="createUserModal" tabindex="-1" aria-labelledby="createUserModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="post">
                <input type="hidden" name="action" value="create">
                <div class="modal-header">
                    <h5 class="modal-title" id="createUserModalLabel">ایجاد کاربر جدید</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="username" class="form-label">نام کاربری <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="username" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">رمز عبور <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="text" class="form-control" id="password" name="password" required>
                            <button class="btn btn-outline-secondary" type="button" onclick="generatePassword()">تصادفی</button>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">ایمیل</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                    <div class="mb-3">
                        <label for="telegram_id" class="form-label">شناسه تلگرام</label>
                        <input type="text" class="form-control" id="telegram_id" name="telegram_id">
                    </div>
                    <div class="mb-3">
                        <label for="expiration" class="form-label">تاریخ انقضا</label>
                        <input type="date" class="form-control" id="expiration" name="expiration">
                        <small class="text-muted">خالی بگذارید برای اشتراک نامحدود</small>
                    </div>
                    <div class="mb-3">
                        <label for="quota" class="form-label">حجم اشتراک (گیگابایت)</label>
                        <input type="number" class="form-control" id="quota" name="quota" min="0">
                        <small class="text-muted">0 بگذارید برای حجم نامحدود</small>
                    </div>
                    <div class="mb-3">
                        <label for="max_devices" class="form-label">حداکثر دستگاه‌ها</label>
                        <input type="number" class="form-control" id="max_devices" name="max_devices" min="1" value="1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-success">ایجاد کاربر</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- مودال حذف کاربر -->
<div class="modal fade" id="deleteUserModal" tabindex="-1" aria-labelledby="deleteUserModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="" method="post">
                <input type="hidden" name="action" value="delete">
                <input type="hidden" name="user_ids[]" id="deleteUserId">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteUserModalLabel">حذف کاربر</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>آیا از حذف کاربر <strong id="deleteUserName"></strong> اطمینان دارید؟</p>
                    <p class="text-danger">این عمل غیرقابل بازگشت است!</p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">انصراف</button>
                    <button type="submit" class="btn btn-danger">حذف کاربر</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // ایجاد رمز عبور تصادفی
    function generatePassword() {
        const chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        let password = '';
        for (let i = 0; i < 8; i++) {
            password += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        document.getElementById('password').value = password;
    }
    
    // نمایش مودال حذف کاربر
    function deleteUser(userId, username) {
        document.getElementById('deleteUserId').value = userId;
        document.getElementById('deleteUserName').textContent = username;
        var deleteModal = new bootstrap.Modal(document.getElementById('deleteUserModal'));
        deleteModal.show();
    }
</script> 