<?php
require_once '../config/db.php';
require_once 'jwt_helper.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user || !password_verify($password, $user['password'])) {
        echo json_encode(["error" => "نام کاربری یا رمز عبور اشتباه است"]);
        exit;
    }
    
    if(isset($user['is_blocked']) && $user['is_blocked'] == 1) {
        echo json_encode(["error" => "این حساب کاربری مسدود شده است"]);
        exit;
    }
    
    $payload = [
        'iss' => 'yourdomain.com',
        'aud' => 'yourdomain.com',
        'iat' => time(),
        'exp' => time() + 3600,
        'data' => [
            'userId' => $user['id'],
            'username' => $user['username']
        ]
    ];
    
    $jwt = generate_jwt($payload);
    echo json_encode(["message" => "ورود موفق", "token" => $jwt]);
}
?>