<?php
// V2Ray Management System Installation Script

// Display errors for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Database configuration
$host = "localhost";
$dbname = "v2ray_db";
$username = "your_db_username";
$password = "your_db_password";

// Function to execute SQL file
function executeSQLFile($pdo, $file) {
    try {
        $sql = file_get_contents($file);
        $pdo->exec($sql);
        return true;
    } catch (PDOException $e) {
        echo "Error executing SQL file: " . $e->getMessage() . "<br>";
        return false;
    }
}

// Function to create directories
function createDirectories() {
    $directories = [
        'uploads',
        'uploads/receipts',
        'uploads/logos',
        'logs'
    ];
    
    foreach ($directories as $dir) {
        if (!file_exists($dir)) {
            if (mkdir($dir, 0755, true)) {
                echo "Created directory: $dir<br>";
            } else {
                echo "Failed to create directory: $dir<br>";
            }
        } else {
            echo "Directory already exists: $dir<br>";
        }
    }
}

// Check if installation is already done
if (file_exists('install_lock.php')) {
    die("Installation is already completed. If you want to reinstall, please delete the 'install_lock.php' file.");
}

// Connect to MySQL server
try {
    $pdo = new PDO("mysql:host=$host", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Create database if not exists
    $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "Database created or already exists.<br>";
    
    // Select the database
    $pdo->exec("USE `$dbname`");
    
    // Execute SQL file
    if (executeSQLFile($pdo, 'database_schema.sql')) {
        echo "Database schema created successfully.<br>";
    } else {
        die("Failed to create database schema.");
    }
    
    // Create necessary directories
    createDirectories();
    
    // Update config file with database credentials
    $configContent = file_get_contents('config/db.php');
    $configContent = str_replace('your_db_username', $username, $configContent);
    $configContent = str_replace('your_db_password', $password, $configContent);
    file_put_contents('config/db.php', $configContent);
    echo "Configuration file updated.<br>";
    
    // Create lock file to prevent reinstallation
    file_put_contents('install_lock.php', '<?php die("Installation is locked."); ?>');
    echo "Installation completed successfully!<br>";
    echo "Please delete this file (install.php) for security reasons.<br>";
    echo "Admin username: admin<br>";
    echo "Admin password: admin123<br>";
    echo "Please change the admin password immediately after login.<br>";
    
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}
?> 