<?php
/**
 * این فایل برای تنظیم webhook ربات تلگرام استفاده می‌شود
 * پس از آپلود فایل‌ها به سرور، این فایل را یک بار اجرا کنید
 */

// فراخوانی فایل‌های مورد نیاز
require_once '../config/db.php';
require_once '../config/settings.php';

// دریافت توکن ربات از تنظیمات
$bot_token = get_setting('telegram_bot_token');

// بررسی اینکه توکن ربات تنظیم شده باشد
if (empty($bot_token)) {
    die("توکن ربات تلگرام تنظیم نشده است. لطفا ابتدا از طریق پنل ادمین، توکن را تنظیم کنید.");
}

// آدرس وب هوک (آدرس فایل bot.php روی سرور شما)
$webhook_url = 'https://your-domain.com/telegram/bot.php';

if (isset($_GET['url'])) {
    $webhook_url = $_GET['url'];
}

// تنظیم وب هوک
$url = "https://api.telegram.org/bot$bot_token/setWebhook";
$data = [
    'url' => $webhook_url,
    'allowed_updates' => ['message', 'callback_query']
];

$options = [
    'http' => [
        'header' => "Content-type: application/x-www-form-urlencoded\r\n",
        'method' => 'POST',
        'content' => http_build_query($data)
    ]
];

$context = stream_context_create($options);
$result = file_get_contents($url, false, $context);

// نمایش نتیجه
echo "<h1>نتیجه تنظیم webhook ربات تلگرام</h1>";
echo "<pre>";
print_r(json_decode($result, true));
echo "</pre>";

// اطلاعات فعلی وب هوک
echo "<h2>اطلاعات فعلی webhook</h2>";
$info_url = "https://api.telegram.org/bot$bot_token/getWebhookInfo";
$info_result = file_get_contents($info_url);
echo "<pre>";
print_r(json_decode($info_result, true));
echo "</pre>";

echo "<p>برای تغییر آدرس وب هوک، می‌توانید پارامتر url را به آدرس جدید اضافه کنید:</p>";
echo "<code>set_webhook.php?url=https://your-new-domain.com/telegram/bot.php</code>";
?> 